local super = require "Object"

Hook = super:new()

function Hook:new(getter, setter)
    self = super.new(self)
    
    self.getter = (type(getter) == 'function' and getter) or (function() return getter end)
    self.setter = setter or function() end
    
    return self
end

function Hook:getValue(...)
    return self.getter(...)
end

function Hook:setValue(...)
    self.setter(...)
end

return Hook
